/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.client.AetherAtlases;
import com.aetherteam.aether.client.AetherColorResolvers;
import com.aetherteam.aether.client.AetherKeys;
import com.aetherteam.aether.client.AetherRecipeCategories;
import com.aetherteam.aether.client.event.listeners.AudioListener;
import com.aetherteam.aether.client.event.listeners.DimensionClientListener;
import com.aetherteam.aether.client.event.listeners.GuiListener;
import com.aetherteam.aether.client.event.listeners.LevelClientListener;
import com.aetherteam.aether.client.event.listeners.MenuListener;
import com.aetherteam.aether.client.event.listeners.abilities.AccessoryAbilityClientListener;
import com.aetherteam.aether.client.gui.screen.inventory.SunAltarScreen;
import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.aetherteam.aether.client.renderer.AetherOverlays;
import com.aetherteam.aether.client.renderer.AetherRenderers;
import com.aetherteam.aether.client.renderer.level.AetherRenderEffects;
import com.aetherteam.aether.event.hooks.AbilityHooks;
import com.aetherteam.aether.event.listeners.ItemListener;
import com.aetherteam.aether.event.listeners.capability.AetherPlayerListener;
import com.aetherteam.aether.inventory.menu.AetherMenuTypes;
import com.aetherteam.aether.inventory.menu.LoreBookMenu;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.mixin.mixins.client.accessor.RecipeBookCategoriesAccessor;
import com.aetherteam.aether.perk.CustomizationsOptions;
import com.aetherteam.aetherfabric.client.AetherFabricClient;
import com.aetherteam.aetherfabric.events.RecipeBookCategoriesHelper;
import com.aetherteam.nitrogen.event.listeners.TooltipListeners;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.Reflection;
import fuzs.forgeconfigapiport.fabric.api.neoforge.v4.client.ConfigScreenFactoryRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_314;
import net.minecraft.class_437;
import net.minecraft.class_5272;
import net.minecraft.class_7417;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;

public class AetherClient
implements ClientModInitializer {
    private static boolean refreshPacks = false;

    public void onInitializeClient() {
        AetherClient.clientSetup();
        AetherClient.eventSetup();
        AetherClient.setupRenderTypes();
        AetherFabricClient.init();
        ConfigScreenFactoryRegistry.INSTANCE.register("aether", ConfigurationScreen::new);
    }

    public static void clientSetup() {
        Reflection.initialize((Class[])new Class[]{CustomizationsOptions.class});
        AetherRenderers.registerAccessoryRenderers();
        AetherAtlases.registerTreasureChestAtlases();
        AetherAtlases.registerWoodTypeAtlases();
        AetherClient.registerItemModelProperties();
        AetherClient.registerTooltipOverrides();
        AetherClient.registerLoreOverrides();
        AetherClient.autoApplyPacks();
        AetherPlayerListener.listenClient();
        ItemListener.listen();
    }

    public static void registerItemModelProperties() {
        class_5272.method_27879((class_1792)((class_1792)AetherItems.PHOENIX_BOW.get()), (class_2960)class_2960.method_60656((String)"pulling"), (stack, world, living, i) -> living != null && living.method_6115() && living.method_6030() == stack ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)((class_1792)AetherItems.PHOENIX_BOW.get()), (class_2960)class_2960.method_60656((String)"pull"), (stack, world, living, i) -> living != null ? (living.method_6030() != stack ? 0.0f : (float)(stack.method_7935(living) - living.method_6014()) / 20.0f) : 0.0f);
        class_5272.method_27879((class_1792)((class_1792)AetherItems.CANDY_CANE_SWORD.get()), (class_2960)class_2960.method_60655((String)"aether", (String)"named"), (stack, world, living, i) -> stack.method_7964().getString().equalsIgnoreCase("green candy cane sword") ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)((class_1792)AetherItems.HAMMER_OF_KINGBDOGZ.get()), (class_2960)class_2960.method_60655((String)"aether", (String)"named"), (stack, world, living, i) -> stack.method_7964().getString().equalsIgnoreCase("hammer of jeb") ? 1.0f : 0.0f);
    }

    public static void registerTooltipOverrides() {
        TooltipListeners.PREDICATES.put(AetherItems.BLUE_GUMMY_SWET, (player, stack, components, context, component) -> {
            class_2588 contents;
            class_7417 patt0$temp;
            if (((Boolean)AetherConfig.SERVER.healing_gummy_swets.get()).booleanValue() && (patt0$temp = component.method_10851()) instanceof class_2588 && (contents = (class_2588)patt0$temp).method_11022().endsWith(".1")) {
                return class_2561.method_43471((String)(contents.method_11022() + ".health"));
            }
            return component;
        });
        TooltipListeners.PREDICATES.put(AetherItems.GOLDEN_GUMMY_SWET, (player, stack, components, context, component) -> {
            class_2588 contents;
            class_7417 patt0$temp;
            if (((Boolean)AetherConfig.SERVER.healing_gummy_swets.get()).booleanValue() && (patt0$temp = component.method_10851()) instanceof class_2588 && (contents = (class_2588)patt0$temp).method_11022().endsWith(".1")) {
                return class_2561.method_43471((String)(contents.method_11022() + ".health"));
            }
            return component;
        });
        TooltipListeners.PREDICATES.put(AetherItems.LIFE_SHARD, (player, stack, components, context, component) -> {
            class_2588 contents;
            class_7417 patt0$temp = component.method_10851();
            if (patt0$temp instanceof class_2588 && (contents = (class_2588)patt0$temp).method_11022().endsWith(".1")) {
                return class_2561.method_43469((String)contents.method_11022(), (Object[])new Object[]{AetherConfig.SERVER.maximum_life_shards.get()});
            }
            return component;
        });
    }

    public static void registerLoreOverrides() {
        LoreBookMenu.addLoreEntryOverride(registryAccess -> stack -> stack.method_31574((class_1792)AetherItems.HAMMER_OF_KINGBDOGZ.get()) && stack.method_7964().getString().equalsIgnoreCase("hammer of jeb"), "lore.item.aether.hammer_of_jeb");
        LoreBookMenu.addLoreEntryOverride(registryAccess -> stack -> class_1799.method_31577((class_1799)stack, (class_1799)AetherItems.createSwetBannerItemStack((class_7871<class_2582>)registryAccess.method_30530(class_7924.field_41252).method_46771())), "lore.item.aether.swet_banner");
    }

    public static void autoApplyPacks() {
        if (FabricLoader.getInstance().isModLoaded("tipsmod")) {
            if (((Boolean)AetherConfig.CLIENT.enable_trivia.get()).booleanValue()) {
                class_310.method_1551().method_1520().method_49427("builtin/aether_tips");
            } else {
                class_310.method_1551().method_1520().method_49428("builtin/aether_tips");
            }
            refreshPacks = true;
        }
    }

    public static void eventSetup() {
        AccessoryAbilityClientListener.listen();
        AudioListener.listen();
        DimensionClientListener.listen();
        GuiListener.listen();
        LevelClientListener.listen();
        MenuListener.listen();
        AetherMenuTypes.registerMenuScreens();
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> AetherColorResolvers.registerBlockColor());
        AetherColorResolvers.registerItemColor();
        AetherKeys.registerKeyMappings();
        AetherRecipeCategories.registerRecipeCategories();
        AetherParticleTypes.registerParticleFactories();
        AetherOverlays.registerOverlays();
        AetherRenderers.registerEntityRenderers();
        AetherRenderers.registerLayerDefinitions();
        AetherRenderers.addEntityLayers();
        AetherRenderEffects.registerRenderEffects();
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> AbilityHooks.ToolHooks.resetDebuffToolsState());
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            HashMap<class_314, ImmutableList<class_314>> aggregatedCategories = new HashMap<class_314, ImmutableList<class_314>>(class_314.field_25783);
            aggregatedCategories.putAll(RecipeBookCategoriesHelper.INSTANCE.aggregateCategories);
            RecipeBookCategoriesAccessor.aetherFabric$setAGGREGATE_CATEGORIES((Map<class_314, List<class_314>>)ImmutableMap.copyOf(aggregatedCategories));
        });
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> AetherClient.loadComplete());
    }

    public static void loadComplete() {
        if (refreshPacks) {
            class_310.method_1551().method_1521();
            refreshPacks = false;
        }
    }

    public static void setToSunAltarScreen(class_2561 name, int timeScale) {
        class_310.method_1551().method_1507((class_437)new SunAltarScreen(name, timeScale));
    }

    public static void setupRenderTypes() {
        class_1921 cutout = class_1921.method_23581();
        BlockRenderLayerMap.INSTANCE.putBlocks(cutout, new class_2248[]{(class_2248)AetherBlocks.BERRY_BUSH.get(), (class_2248)AetherBlocks.BERRY_BUSH_STEM.get(), (class_2248)AetherBlocks.PURPLE_FLOWER.get(), (class_2248)AetherBlocks.WHITE_FLOWER.get(), (class_2248)AetherBlocks.SKYROOT_SAPLING.get(), (class_2248)AetherBlocks.GOLDEN_OAK_SAPLING.get(), (class_2248)AetherBlocks.POTTED_BERRY_BUSH.get(), (class_2248)AetherBlocks.POTTED_BERRY_BUSH_STEM.get(), (class_2248)AetherBlocks.POTTED_PURPLE_FLOWER.get(), (class_2248)AetherBlocks.POTTED_WHITE_FLOWER.get(), (class_2248)AetherBlocks.POTTED_SKYROOT_SAPLING.get(), (class_2248)AetherBlocks.POTTED_GOLDEN_OAK_SAPLING.get(), (class_2248)AetherBlocks.SKYROOT_DOOR.get(), (class_2248)AetherBlocks.SKYROOT_TRAPDOOR.get(), (class_2248)AetherBlocks.AMBROSIUM_TORCH.get(), (class_2248)AetherBlocks.AMBROSIUM_WALL_TORCH.get()});
        class_1921 translucent = class_1921.method_23583();
        BlockRenderLayerMap.INSTANCE.putBlocks(translucent, new class_2248[]{(class_2248)AetherBlocks.AETHER_PORTAL.get(), (class_2248)AetherBlocks.COLD_AERCLOUD.get(), (class_2248)AetherBlocks.BLUE_AERCLOUD.get(), (class_2248)AetherBlocks.GOLDEN_AERCLOUD.get(), (class_2248)AetherBlocks.QUICKSOIL_GLASS.get(), (class_2248)AetherBlocks.QUICKSOIL_GLASS_PANE.get(), (class_2248)AetherBlocks.AEROGEL.get(), (class_2248)AetherBlocks.AEROGEL_WALL.get(), (class_2248)AetherBlocks.AEROGEL_SLAB.get(), (class_2248)AetherBlocks.AEROGEL_STAIRS.get()});
    }
}

